// Tracker.h: interface for the Tracker class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACKER_H__ED6B372F_D7A0_4F6A_B2EC_D74EB9846669__INCLUDED_)
#define AFX_TRACKER_H__ED6B372F_D7A0_4F6A_B2EC_D74EB9846669__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include <iostream.h>
#include <fstream.h>
#include <math.h>

#include "TRACK_FOR_TRACKER.h"
#include "alphabeta.h"

const int MAX_PINGS			=  2000;
const int MAX_TRACKS		=  2000;
const int MAX_ECHOES		= 20000;
const int NOT_VALID			= -1001;
const int MAX_ECHO_PING		=   500;
const int REALLY_BIG_NUMBER = 1000000;


struct ECHO_FOR_TRACKS {
	int		pingNumber;
	int		echoNumber;
	double	range;
	int		trackAssociation;

	// We may want this stuff
	int		classification;
	float	confidence;
	float	correlation;
	float	targetStrength;

	// other stuff to add ????
	//...
	/*
	-Average Spectral data
	-Average Acoustic Color
	-


		
	*/
};

class Tracker  
{
public:
	int getNumEchoesInCurrentPing();
	int getCurrentPingNumber();
	int dummyTracker();
	int LogNum;
	long testTracker(short testToRun);
	int dumpDataToFile();

	void Tracker::initTracker();
	bool addNewEcho(long pingNum, long echoNum);
	bool setTS(long pingNum, long echoNum, float value);
	bool setRange(long pingNum, long echoNum, float value);
	bool setCorrelation(long pingNum, long echoNum, float value);
	bool setConfidence(long pingNum, long echoNum, float value);
	bool setClassification(long pingNum, long echoNum, long value);
	double getAverageTrackTS(long trackNum);
	long getTrackAssoc(long pingNum, long echoNum);
	void set_trackerParamJPDA (double alphaIn, double betaIn, double initGateIn,double probOfDetectIn, double extraneousDetectIn);
	void set_trackerParamAlphaBeta( double alpha, double beta, long gate);
	int associateTracks();
	Tracker();
	virtual ~Tracker();
	int		findTracks(int uid);	// testing only

private:
	void algo_alphaBeta_V1_prediction();
	void algo_alphaBeta_V1_association();
	int initialTrackSetup(int currentPingNumber);
	int algo_JPDA_V1();
	int algo_alphaBeta_V1();
	int findEcho(int pingNum, int echoNum);
	//flags
	bool	trackerOn;
	int		algorithm;

	// parameters		
	double	alpha;		// Alpha Beta, JPDA
	double	beta;		// Alpha Beta, JPDA

	long	gate;		// Alpha Beta (only)

	double	initGate;			// JDPA (only)

	double	probDetect;			// JDPA (only)	
	double	extraneousDetect;	// JDPA (only)

//data
	int pingIndex[MAX_PINGS];
	int indexOfLiveTracks[MAX_TRACKS];
	ECHO_FOR_TRACKS echoList[MAX_ECHOES];
	TRACK_FOR_TRACKER	tracks[MAX_TRACKS];
	TRACK_FOR_TRACKER	export[MAX_TRACKS];

//bookkeeping
	int countEchoes;
	int countTracks;	
	int countPings;
	int countLive;

	void logToFile(int n, char * output);
	int addTrack();
	int pruneLiveTracks();
	
};

#endif // !defined(AFX_TRACKER_H__ED6B372F_D7A0_4F6A_B2EC_D74EB9846669__INCLUDED_)
